/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.routes;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.routes.IVWConditionParameterSource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VWResponsePanel
extends JPanel
implements IVWConditionParameterSource,
IVWPropertyChangeListener,
ActionListener {
    private static final String CONDITION_ALL = "ALL";
    private static final String CONDITION_NONE = "NONE";
    private static final String CONDITION_ANY = "ANY";
    private static final String CONDITION_COUNT = "COUNT";
    private static final String OPERATOR_EQUAL = " = ";
    private static final String OPERATOR_NOT_EQUAL = " <> ";
    private static final String OPERATOR_GREATER_THAN = " > ";
    private static final String OPERATOR_GREATER_THAN_OR_EQUAL = " >= ";
    private static final String OPERATOR_LESS_THAN = " < ";
    private static final String OPERATOR_LESS_THAN_OR_EQUAL = " <= ";
    private static final String PARENTHESIS_LEFT = "(";
    private static final String PARENTHESIS_RIGHT = ")";
    private JComboBox m_conditionCombo = null;
    private JComboBox m_responseCombo = null;
    private JComboBox m_operatorsCombo = null;
    private JTextField m_valueTextField = null;
    private Vector m_controls = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWRouteDefinition m_routeDefinition = null;

    public VWResponsePanel(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_controls = new Vector();
            this.createControls();
            authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setEnabled(boolean bEnable) {
        super.setEnabled(bEnable);
        if (this.m_controls == null) {
            return;
        }
        for (int i = 0; i < this.m_controls.size(); ++i) {
            JComponent component = (JComponent)this.m_controls.elementAt(i);
            if (component == null) continue;
            component.setEnabled(bEnable);
        }
        if (bEnable) {
            this.enableExtraControls();
        }
    }

    public String getConditionString() {
        try {
            String conditionString = (String)this.m_conditionCombo.getSelectedItem();
            if (VWStringUtils.compare(conditionString, VWResource.s_conditionAll) == 0) {
                conditionString = CONDITION_ALL;
            } else if (VWStringUtils.compare(conditionString, VWResource.s_conditionNone) == 0) {
                conditionString = CONDITION_NONE;
            } else if (VWStringUtils.compare(conditionString, VWResource.s_conditionAny) == 0) {
                conditionString = CONDITION_ANY;
            } else if (VWStringUtils.compare(conditionString, VWResource.s_conditionCount) == 0) {
                conditionString = CONDITION_COUNT;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(conditionString + PARENTHESIS_LEFT);
            buffer.append((String)this.m_responseCombo.getSelectedItem() + PARENTHESIS_RIGHT);
            if (VWStringUtils.compare(conditionString, CONDITION_COUNT) == 0) {
                String opString = (String)this.m_operatorsCombo.getSelectedItem();
                if (VWStringUtils.compare(opString, VWResource.s_isEqualOp) == 0) {
                    opString = OPERATOR_EQUAL;
                } else if (VWStringUtils.compare(opString, VWResource.s_notEqualOp) == 0) {
                    opString = OPERATOR_NOT_EQUAL;
                } else if (VWStringUtils.compare(opString, VWResource.s_isGreaterThanOp) == 0) {
                    opString = OPERATOR_GREATER_THAN;
                } else if (VWStringUtils.compare(opString, VWResource.s_isGreaterThanOrEqualOp) == 0) {
                    opString = OPERATOR_GREATER_THAN_OR_EQUAL;
                } else if (VWStringUtils.compare(opString, VWResource.s_isLessThanOp) == 0) {
                    opString = OPERATOR_LESS_THAN;
                } else if (VWStringUtils.compare(opString, VWResource.s_isLessThanOrEqualOp) == 0) {
                    opString = OPERATOR_LESS_THAN_OR_EQUAL;
                }
                buffer.append(opString);
                buffer.append(this.m_valueTextField.getText());
            }
            return buffer.toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        try {
            if (this.m_routeDefinition == null) {
                return;
            }
            switch (event.getID()) {
                case 536: 
                case 537: 
                case 538: 
                case 539: {
                    this.setSelectedRoute(this.m_routeDefinition);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_conditionCombo) {
            this.enableExtraControls();
        }
    }

    protected void setSelectedRoute(VWRouteDefinition routeDefinition) {
        try {
            VWMapNode mapNode;
            this.m_routeDefinition = routeDefinition;
            String[] responses = null;
            if (this.m_routeDefinition != null && (mapNode = this.m_routeDefinition.getSourceStep()) != null && mapNode instanceof VWStepDefinition) {
                responses = ((VWStepDefinition)mapNode).getResponses();
            }
            this.initializeComboBox(this.m_responseCombo, responses);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        if (this.m_conditionCombo != null) {
            this.m_conditionCombo.removeActionListener(this);
            this.m_conditionCombo.removeAll();
            this.m_conditionCombo = null;
        }
        if (this.m_responseCombo != null) {
            this.m_responseCombo.removeAll();
            this.m_responseCombo = null;
        }
        if (this.m_operatorsCombo != null) {
            this.m_operatorsCombo.removeAll();
            this.m_operatorsCombo = null;
        }
        if (this.m_valueTextField != null) {
            this.m_valueTextField.removeAll();
            this.m_valueTextField = null;
        }
        if (this.m_controls != null) {
            this.m_controls.removeAllElements();
            this.m_controls = null;
        }
        this.m_authPropertyData = null;
        this.m_routeDefinition = null;
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = -1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(2, 4, 2, 4);
            JLabel label = new JLabel(VWResource.s_conditionStr);
            this.m_controls.addElement(label);
            this.add((Component)label, gbCons);
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_conditionCombo = new JComboBox();
            this.m_conditionCombo.setName("m_conditionCombo_VWResponsePanel");
            this.m_conditionCombo.addItem(VWResource.s_conditionAll);
            this.m_conditionCombo.addItem(VWResource.s_conditionNone);
            this.m_conditionCombo.addItem(VWResource.s_conditionAny);
            this.m_conditionCombo.addItem(VWResource.s_conditionCount);
            this.m_conditionCombo.addActionListener(this);
            this.m_conditionCombo.setRenderer(new VWLabelListCellRenderer());
            this.m_controls.addElement(this.m_conditionCombo);
            this.add((Component)this.m_conditionCombo, gbCons);
            gbCons.gridwidth = -1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            label = new JLabel(VWResource.s_responseStr);
            this.m_controls.addElement(label);
            this.add((Component)label, gbCons);
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_responseCombo = new JComboBox();
            this.m_responseCombo.setName("m_responseCombo_VWResponsePanel");
            this.m_responseCombo.setRenderer(new VWLabelListCellRenderer());
            this.add((Component)this.m_responseCombo, gbCons);
            this.m_controls.addElement(this.m_responseCombo);
            gbCons.gridwidth = -1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            label = new JLabel(VWResource.s_operatorStr);
            this.m_controls.addElement(label);
            this.add((Component)label, gbCons);
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_operatorsCombo = new JComboBox();
            this.m_operatorsCombo.setName("m_operatorsCombo_VWResponsePanel");
            this.m_operatorsCombo.addItem(VWResource.s_isEqualOp);
            this.m_operatorsCombo.addItem(VWResource.s_notEqualOp);
            this.m_operatorsCombo.addItem(VWResource.s_isGreaterThanOp);
            this.m_operatorsCombo.addItem(VWResource.s_isGreaterThanOrEqualOp);
            this.m_operatorsCombo.addItem(VWResource.s_isLessThanOp);
            this.m_operatorsCombo.addItem(VWResource.s_isLessThanOrEqualOp);
            this.m_operatorsCombo.setRenderer(new VWLabelListCellRenderer());
            this.m_controls.addElement(this.m_operatorsCombo);
            this.add((Component)this.m_operatorsCombo, gbCons);
            gbCons.gridwidth = -1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            label = new JLabel(VWResource.s_value);
            this.m_controls.addElement(label);
            this.add((Component)label, gbCons);
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_valueTextField = new JTextField(10);
            this.m_valueTextField.setName("m_valueTextField_VWResponsePanel");
            this.m_controls.addElement(this.m_valueTextField);
            this.add((Component)this.m_valueTextField, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initializeComboBox(JComboBox comboBox, String[] items) {
        try {
            DefaultComboBoxModel<Object> dataModel = new DefaultComboBoxModel();
            if (items != null) {
                dataModel = new DefaultComboBoxModel<String>(items);
            }
            comboBox.setModel(dataModel);
            if (comboBox.getItemCount() > 0) {
                comboBox.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void enableExtraControls() {
        boolean bEnable = false;
        String conditionString = (String)this.m_conditionCombo.getSelectedItem();
        if (VWStringUtils.compare(conditionString, VWResource.s_conditionCount) == 0) {
            bEnable = true;
        }
        this.m_operatorsCombo.setEnabled(bEnable);
        this.m_valueTextField.setEnabled(bEnable);
    }
}

